--===============================================================================================
--      Display the file sizes before the test run.
--      ***** WARNING *****
--      This creates a 52.400GB MDF file and an 87.950GB Log file depending on which test is run.
--       Copyright - Jeff Moden, 18 August 2023, All Rights Reserved
--===============================================================================================
--===== Notify the operator.
        RAISERROR('Display the starting file sizes.',0,0) WITH NOWAIT
;
--===== Do this in the correct database.
    USE MinLogTest
;
--===== Make sure everything has been written to disk.
CHECKPOINT
;
--===== Display the file sizes in whole megabytes
 SELECT  StartMdfSizeMB = SUM(IIF(type_desc = 'ROWS', size/128, 0))
        ,StartLdfSizeMB = SUM(IIF(type_desc = 'LOG' , size/128, 0))
   FROM sys.database_files
;
--===============================================================================================
--      Create the test table and the Clustered Index.
--===============================================================================================
--===== Notify the operator.
        RAISERROR('Creating the test table with a clustered index.',0,0) WITH NOWAIT
;
--===== Create the test table.
 CREATE TABLE dbo.BigTable
        (
         RowNum     INT          IDENTITY(1,1),      
         ProductID  CHAR(3)      NOT NULL            
        ,Amount     DECIMAL(9,2) NOT NULL            
        ,Quantity   SMALLINT     NOT NULL            
        ,TransDT    DATETIME     NOT NULL            
        ,OtherCols  CHAR(500)    NOT NULL DEFAULT 'X'
        )
;
--===== Add a temporally based Clustered Index to support reporting.
 CREATE CLUSTERED INDEX CI_ByTransDTProductID
     ON dbo.BigTable (TransDT,ProductID)
;
--===============================================================================================
--      Populate the test table with "Minimal Logging".
--===============================================================================================
--===== Notify the operator.
        RAISERROR('Test is running. This will take a few minutes.',0,0) WITH NOWAIT
;
--===== Variables to control dates and number of rows in the test table.
DECLARE  @StartDT   DATETIME = '2010'    
        ,@EndDT     DATETIME = '2020'    
        ,@Rows      INT      = 100000000;
DECLARE  @Days      INT      = DATEDIFF(dd,@StartDT,@EndDT)
;
--===== Populate the test table using "Minimal Logging".
 INSERT INTO dbo.BigTable WITH (TABLOCK) -- TABLOCK required for minimal loggimg
        (ProductID, Amount, Quantity, TransDT)
 SELECT  ProductID  = CHAR(ABS(CHECKSUM(NEWID())%2)+65)
                    + CHAR(ABS(CHECKSUM(NEWID())%2)+65)
                    + CHAR(ABS(CHECKSUM(NEWID())%2)+65)
        ,Amount     = RAND(CHECKSUM(NEWID()))*100
        ,Quantity   = ABS(CHECKSUM(NEWID())%50)+1
        ,TransDT    = RAND(CHECKSUM(NEWID()))*@Days+@StartDT
 --FROM GENERATE_SERIES(1,@Rows) --TODO uncomment one or the other FROM clause for different test.
   FROM dbo.fnTally(1,@Rows)     --TODO uncomment one or the other FROM clause for different test.
  ORDER BY TransDT,ProductID -- Inserts must be in same order as Clustered Index.
 OPTION (RECOMPILE) -- Undocumented but essential for minimal logging when variables are used.
;
--===============================================================================================
--      Display the file sizes before the test run.
--===============================================================================================
--===== Notify the operator.
        RAISERROR('Display the ending file sizes.',0,0) WITH NOWAIT
;
--===== Make sure everything has been written to disk.
CHECKPOINT
;
--===== Display the file sizes in whole megabytes
 SELECT  EndMdfSizeMB = SUM(IIF(type_desc = 'ROWS', size/128, 0))
        ,EndLdfSizeMB = SUM(IIF(type_desc = 'LOG' , size/128, 0))
   FROM sys.database_files
;
--===== Notify the operator.
        RAISERROR('Run complete.',0,0) WITH NOWAIT
;